Function Main As String
' Show molecular-tree methods
' The program generates and 3D-optimizes molecules HO-(CH2)n-COOH, n=1-5

' THE EXAMPLE ILLUSTRATES THE USE OF:
'   AddEmpty
'   GetHeight
'   GetWidth
'   Molecules
'   NewAtom
'   Add
'   AddBond
'   Do3DOptimize
'   Depict




Dim n,i,ph,pw,l,t,w,h,k As Integer
Dim Ent,Mol,Oh, Cox,O1ox,O2ox,AtomCurr,AtomPrev, Page,Diagram, Struc As Object
Const title="SHOW MOLECULAR-TREE OBJECTS METHODS"
Const nmax=5

  i=MessageBox("Press OK to generate carbonic acids HO-(CH2)n-COOH, n=1-5", title, MBB_OK + MBI_EXCLAMATION)
  'Create new empty page
  Page=ActiveDocument.AddEmpty
  'Read out page parameters
  ph=Page.GetHeight
  pw=Page.GetWidth

  'In a loop ....
  For n=1 to nmax

    'Create new assembly
    Ent=Assemblies.AddEmpty
    Mol=Ent.Molecules.AddEmpty
    'Add OH (note that we will not add implicit hydrogen)
    Oh=NewAtom(8) :Ent.Add(Oh)
    'Add COOH
    Cox=NewAtom(6) : Ent.Add(Cox)
    O1ox=NewAtom(8): Ent.Add(O1ox)
    O2ox=NewAtom(8): Ent.Add(O2ox)
    'Make bonds
    Mol.AddBond(Cox,O1ox,2) : Mol.AddBond(Cox,O2ox,1) :AtomPrev=Oh
    'Add (CH2)n
    For i=1 To n
      AtomCurr=NewAtom(6) :Mol.AddBond(AtomCurr,AtomPrev,1) :AtomPrev=AtomCurr
    Next i
    Mol.AddBond(AtomPrev,Cox,1)

    'Optimize a structure
    Struc=Mol.Do3DOptimize(0.1)
    'Depict as a ChemSketch diagram
    Diagram=Page.Diagrams.AddEmpty
    Diagram.Depict(Struc)
    'Adjust diagram's position
    Diagram.GetBound(l,t,w,h)
    Diagram.SetBound(Int(pw/3),200+(n-1)*Int(ph/(nmax+1)),w,h)

  Next n


ShutDown:
  Main="Demo completed"
End Function
